#include <stdio.h>
#include <string.h>

typedef struct {
	char naziv[50];
	char autor[50];
	float trajanje;
} pesma;

int UcitajPesme (char nazivFajla[], pesma pesme[]) {
	int i = 0, duzina;
	
	FILE *f = fopen(nazivFajla, "r");
	
	while (!feof(f)) {
		fscanf(f, "%s", pesme[i].naziv);
		fscanf(f, "%s", pesme[i].autor);
		fscanf(f, "%f", &pesme[i].trajanje);
		
		i++;
	}
	
	fclose(f);
	
	return i;
}

void IspisPlejliste (char nazivFajla[], pesma pesme[], int n) {
	int i;
	
	FILE *f = fopen(nazivFajla, "w");
	
	for (i = 0; i < n; i++) 
		fprintf(f, "%s, %s - %.2f\n", pesme[i].naziv, pesme[i].autor, pesme[i].trajanje);
	
	fclose(f);
}

int BozicnaPesma (char nazivPesme[]) {
	int i, j;
	char substring[] = "Christmas";
	
	for (i = 0; nazivPesme[i] != '\0'; i++) {
		for (j = 0; nazivPesme[i + j] == substring[j]; j++);
			
		if (substring[j + 1] == '\0')
			return 1;
	}
	
	return 0;
}

int KreirajPlejlistu (pesma pesme[], int n, pesma plejlista[]) {
	int i, duzinaListe = 0;
	
	for (i = 0; i < n; i++)
		if (BozicnaPesma(pesme[i].naziv)) {
			plejlista[duzinaListe] = pesme[i];
			duzinaListe++;	
		}
		
	return duzinaListe;
}

main () {
	char ulazniFajl[30], izlazniFajl[30];
	int n, brojBozicnih;
	pesma pesme[20], plejlista[20];
	
	scanf("%s%s", ulazniFajl, izlazniFajl);
	
	n = UcitajPesme(ulazniFajl, pesme);
	brojBozicnih = KreirajPlejlistu(pesme, n, plejlista);
	IspisPlejliste(izlazniFajl, plejlista, brojBozicnih);
}
